#ifndef CRYS_C2_ERROR_H
#define CRYS_C2_ERROR_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS_error.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object % CRYS_C2_error.h    : %
   *  State           :  %state%
   *  Creation date   :  Feb. 19 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This module containes the definitions of the CRYS C2 errors.
   *
   *  \version CRYS_C2_error.h#1:incl:1
   *  \author R. Levin (using as templet the DES files of adams).
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */




/************************ Defines ******************************/

/* The CRYS C2 Cipher module errors */
#define CRYS_C2_CIPHER_INVALID_USER_CONTEXT_POINTER_ERROR   (CRYS_C2_MODULE_ERROR_BASE + 0x0UL)
#define CRYS_C2_CIPHER_ILLEGAL_OPERATION_MODE_ERROR         (CRYS_C2_MODULE_ERROR_BASE + 0x1UL)
#define CRYS_C2_CIPHER_INVALID_KEY_POINTER_ERROR            (CRYS_C2_MODULE_ERROR_BASE + 0x2UL)
#define CRYS_C2_CIPHER_INVALID_ENCRYPT_MODE_ERROR           (CRYS_C2_MODULE_ERROR_BASE + 0x3UL)
#define CRYS_C2_CIPHER_USER_CONTEXT_CORRUPTED_ERROR         (CRYS_C2_MODULE_ERROR_BASE + 0x4UL) 
#define CRYS_C2_CIPHER_DATA_IN_POINTER_INVALID_ERROR        (CRYS_C2_MODULE_ERROR_BASE + 0x5UL)
#define CRYS_C2_CIPHER_DATA_OUT_POINTER_INVALID_ERROR       (CRYS_C2_MODULE_ERROR_BASE + 0x6UL)
#define CRYS_C2_CIPHER_DATA_SIZE_ILLEGAL                    (CRYS_C2_MODULE_ERROR_BASE + 0x7UL)
#define CRYS_C2_CIPHER_DATA_OUT_DATA_IN_OVERLAP_ERROR       (CRYS_C2_MODULE_ERROR_BASE + 0x8UL)

/* The CRYS C2 HASH module errors */
#define CRYS_C2_HASH_INVALID_USER_CONTEXT_POINTER_ERROR     (CRYS_C2_MODULE_ERROR_BASE + 0x10UL)
#define CRYS_C2_HASH_USER_CONTEXT_CORRUPTED_ERROR           (CRYS_C2_MODULE_ERROR_BASE + 0x11UL) 
#define CRYS_C2_HASH_DATA_IN_POINTER_INVALID_ERROR          (CRYS_C2_MODULE_ERROR_BASE + 0x12UL)
#define CRYS_C2_HASH_DATA_SIZE_ILLEGAL                      (CRYS_C2_MODULE_ERROR_BASE + 0x13UL)
#define CRYS_C2_HASH_INVALID_RESULT_BUFFER_POINTER_ERROR    (CRYS_C2_MODULE_ERROR_BASE + 0x14UL)

/* The CRYS C2 One Way function errors */
#define CRYS_C2_ONE_WAY_FUNC_DATA1_POINTER_INVALID_ERROR    (CRYS_C2_MODULE_ERROR_BASE + 0x20UL)
#define CRYS_C2_ONE_WAY_FUNC_DATA2_POINTER_INVALID_ERROR    (CRYS_C2_MODULE_ERROR_BASE + 0x21UL)
#define CRYS_C2_ONE_WAY_FUNC_DATA_OUT_POINTER_INVALID_ERROR (CRYS_C2_MODULE_ERROR_BASE + 0x22UL)
#define CRYS_C2_ONE_WAY_FUNC_IN_OUT_OVERLAP_ERROR           (CRYS_C2_MODULE_ERROR_BASE + 0x23UL)	

/*************/
#define CRYS_C2_IS_NOT_SUPPORTED                            (CRYS_C2_MODULE_ERROR_BASE + 0xFFUL)

/************************ Enums ********************************/


/************************ Typedefs  ****************************/


/************************ Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/

#ifdef __cplusplus
}
#endif

#endif


